<?php
require_once __DIR__ . '/../includes/auth_check.php';

$currentUser = current_user();
$pageTitle = 'Profile';
$db = db_connection();

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    if ($name !== '' && $currentUser) {
        $stmt = $db->prepare('UPDATE users SET name = ? WHERE id = ?');
        $stmt->bind_param('si', $name, $currentUser['id']);
        $stmt->execute();
        $stmt->close();
        $message = 'Profile updated.';
        $currentUser['name'] = $name;
    }
}

include __DIR__ . '/../includes/header.php';
?>
    <section class="card">
        <div class="card-header">
            <div>
                <h3>Your profile</h3>
                <span>Manage basic account details</span>
            </div>
        </div>
        <?php if ($message !== ''): ?>
            <div class="alert" style="background:rgba(34,197,94,0.12);border:1px solid rgba(34,197,94,0.6);color:#166534">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>
        <form method="post" style="max-width:340px">
            <div class="form-group">
                <label for="name">Full name</label>
                <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($currentUser['name'] ?? ''); ?>" required>
            </div>
            <div class="form-group">
                <label>Email</label>
                <input type="email" value="<?php echo htmlspecialchars($currentUser['email'] ?? ''); ?>" disabled>
            </div>
            <button type="submit" class="btn-primary" style="width:auto;padding-inline:16px">Save changes</button>
            <a href="logout.php" style="margin-left:8px;font-size:12px;color:#ef4444">Logout</a>
        </form>
    </section>
<?php
include __DIR__ . '/../includes/footer.php';
