<?php
require_once __DIR__ . '/../includes/auth_check.php';

$currentUser = current_user();
$pageTitle = 'Payouts';
$db = db_connection();

$stmt = $db->prepare('SELECT id, amount, status, requested_at, paid_at FROM payouts WHERE user_id = ? ORDER BY requested_at DESC');
$stmt->bind_param('i', $_SESSION['user_id']);
$stmt->execute();
$payouts = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();

include __DIR__ . '/../includes/header.php';
?>
    <section class="card">
        <div class="card-header">
            <div>
                <h3>Payout history</h3>
                <span>Track your withdrawals</span>
            </div>
        </div>
        <table class="table-simple">
            <thead>
            <tr>
                <th>Amount</th>
                <th>Status</th>
                <th>Requested</th>
                <th>Paid</th>
            </tr>
            </thead>
            <tbody>
            <?php if (!$payouts): ?>
                <tr>
                    <td colspan="4" style="font-size:12px;color:var(--text-muted)">No payout requests yet.</td>
                </tr>
            <?php else: ?>
                <?php foreach ($payouts as $row): ?>
                    <tr>
                        <td>$<?php echo number_format($row['amount'], 2); ?></td>
                        <td>
                            <?php
                            $badgeClass = 'badge-neutral';
                            if ($row['status'] === 'paid') {
                                $badgeClass = 'badge-success';
                            } elseif ($row['status'] === 'pending') {
                                $badgeClass = 'badge-warning';
                            }
                            ?>
                            <span class="badge <?php echo $badgeClass; ?>"><?php echo htmlspecialchars($row['status']); ?></span>
                        </td>
                        <td><?php echo htmlspecialchars($row['requested_at']); ?></td>
                        <td><?php echo htmlspecialchars($row['paid_at'] ?: '-'); ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
            </tbody>
        </table>
    </section>
<?php
include __DIR__ . '/../includes/footer.php';
