<?php
if (!isset($pageTitle)) {
    $pageTitle = 'Task Dashboard';
}
if (!isset($currentUser)) {
    $currentUser = null;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($pageTitle); ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
<div class="app-shell">
    <?php if (empty($hideSidebar)): ?>
    <aside class="sidebar">
        <div class="sidebar-logo">
            <div class="sidebar-logo-badge">TD</div>
            <div>
                <div>Task Dashboard</div>
                <small style="font-size:11px;color:rgba(148,163,184,0.9)">Earn by completing tasks</small>
            </div>
        </div>
        <nav class="sidebar-nav">
            <a href="../user/dashboard.php" class="sidebar-link active">
                <span class="icon">🏠</span>
                <span>Dashboard</span>
            </a>
            <a href="../user/tasks.php" class="sidebar-link">
                <span class="icon">📝</span>
                <span>Tasks</span>
            </a>
            <a href="../user/wallet.php" class="sidebar-link">
                <span class="icon">💳</span>
                <span>Wallet</span>
            </a>
            <a href="../user/payouts.php" class="sidebar-link">
                <span class="icon">💸</span>
                <span>Payouts</span>
            </a>
            <a href="../user/profile.php" class="sidebar-link">
                <span class="icon">👤</span>
                <span>Profile</span>
            </a>
        </nav>
    </aside>
    <?php endif; ?>
    <div class="main-area">
        <header class="app-header">
            <div class="header-left">
                <h2><?php echo htmlspecialchars($pageTitle); ?></h2>
                <span>Position now earning in real time</span>
            </div>
            <div class="header-right">
                <div class="theme-toggle" data-theme-toggle>
                    <span class="sun">☀</span>
                    <span class="moon">🌙</span>
                    <div class="theme-toggle-thumb"></div>
                </div>
                <div class="avatar-pill">
                    <div class="avatar-circle">
                        <?php
                        $initials = 'U';
                        if ($currentUser && isset($currentUser['name'])) {
                            $parts = preg_split('/\s+/', trim($currentUser['name']));
                            if ($parts && $parts[0] !== '') {
                                $initials = strtoupper(mb_substr($parts[0], 0, 1, 'UTF-8'));
                            }
                        }
                        echo htmlspecialchars($initials);
                        ?>
                    </div>
                    <span><?php echo $currentUser ? htmlspecialchars($currentUser['name']) : 'Guest'; ?></span>
                </div>
            </div>
        </header>
        <main class="main-content">
