<?php
session_start();

if (!file_exists(__DIR__ . '/../config/config.php')) {
    header('Location: ../../install.php');
    exit;
}

require_once __DIR__ . '/../config/config.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: ' . BASE_URL . 'login');
    exit;
}

function current_user()
{
    if (!isset($_SESSION['user_id'])) {
        return null;
    }
    $db = db_connection();
    $stmt = $db->prepare('SELECT id, name, email, role FROM users WHERE id = ? LIMIT 1');
    $stmt->bind_param('i', $_SESSION['user_id']);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    $stmt->close();
    return $user ?: null;
}

function require_admin()
{
    $user = current_user();
    if (!$user || $user['role'] !== 'admin') {
        header('Location: ' . BASE_URL . 'dashboard');
        exit;
    }
}
