<?php
require_once __DIR__ . '/../app/includes/auth_check.php';

require_admin();
$currentUser = current_user();
$pageTitle = 'Users';
$db = db_connection();

if (empty($_SESSION['csrf_token_admin_manage'])) {
    $_SESSION['csrf_token_admin_manage'] = bin2hex(random_bytes(16));
}

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $token = $_POST['csrf_token'] ?? '';
    if (hash_equals($_SESSION['csrf_token_admin_manage'], $token)) {
        $userId = (int)($_POST['user_id'] ?? 0);
        $role = $_POST['role'] ?? '';
        if (in_array($role, ['user', 'admin'], true) && $userId > 0 && $userId !== $currentUser['id']) {
            $stmt = $db->prepare('UPDATE users SET role = ? WHERE id = ?');
            $stmt->bind_param('si', $role, $userId);
            $stmt->execute();
            $stmt->close();
            $message = 'User updated.';
        }
    }
}

$res = $db->query('SELECT id, name, email, role, created_at FROM users ORDER BY created_at DESC');
$users = $res ? $res->fetch_all(MYSQLI_ASSOC) : [];

include __DIR__ . '/admin_header.php';
?>
    <section class="card">
        <div class="card-header">
            <div>
                <h3>Manage users</h3>
                <span>Promote admins and review accounts</span>
            </div>
        </div>
        <?php if ($message !== ''): ?>
            <div class="alert" style="background:rgba(34,197,94,0.12);border:1px solid rgba(34,197,94,0.6);color:#166534">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>
        <table class="table-simple">
            <thead>
            <tr>
                <th>Name</th>
                <th>Email</th>
                <th>Role</th>
                <th>Joined</th>
                <th>Actions</th>
            </tr>
            </thead>
            <tbody>
            <?php if (!$users): ?>
                <tr>
                    <td colspan="5" style="font-size:12px;color:var(--text-muted)">No users found.</td>
                </tr>
            <?php else: ?>
                <?php foreach ($users as $user): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($user['name']); ?></td>
                        <td><?php echo htmlspecialchars($user['email']); ?></td>
                        <td><?php echo htmlspecialchars($user['role']); ?></td>
                        <td><?php echo htmlspecialchars($user['created_at']); ?></td>
                        <td>
                            <?php if ($user['id'] !== $currentUser['id']): ?>
                                <form method="post" style="display:inline-flex;gap:4px;align-items:center">
                                    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($_SESSION['csrf_token_admin_manage']); ?>">
                                    <input type="hidden" name="user_id" value="<?php echo (int)$user['id']; ?>">
                                    <select name="role" style="font-size:11px;border-radius:999px;padding:3px 8px">
                                        <option value="user" <?php echo $user['role'] === 'user' ? 'selected' : ''; ?>>user</option>
                                        <option value="admin" <?php echo $user['role'] === 'admin' ? 'selected' : ''; ?>>admin</option>
                                    </select>
                                    <button type="submit" style="font-size:11px;border-radius:999px;padding:4px 9px;border:none;background:var(--accent-soft);color:var(--accent-primary);cursor:pointer">
                                        Save
                                    </button>
                                </form>
                            <?php else: ?>
                                <span style="font-size:11px;color:var(--text-muted)">You</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
            </tbody>
        </table>
    </section>
<?php
include __DIR__ . '/admin_footer.php';
