<?php
require_once __DIR__ . '/../app/includes/auth_check.php';

require_admin();
$currentUser = current_user();
$pageTitle = 'Tasks';
$db = db_connection();

if (empty($_SESSION['csrf_token_admin_tasks'])) {
    $_SESSION['csrf_token_admin_tasks'] = bin2hex(random_bytes(16));
}

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $token = $_POST['csrf_token'] ?? '';
    if (hash_equals($_SESSION['csrf_token_admin_tasks'], $token)) {
        if (isset($_POST['create_task'])) {
            $title = trim($_POST['title'] ?? '');
            $reward = (float)($_POST['reward_amount'] ?? 0);
            $description = trim($_POST['description'] ?? '');
            if ($title !== '' && $reward > 0) {
                $stmt = $db->prepare('INSERT INTO tasks (title, description, reward_amount) VALUES (?, ?, ?)');
                $stmt->bind_param('ssd', $title, $description, $reward);
                $stmt->execute();
                $stmt->close();
                $message = 'Task created.';
            }
        } elseif (isset($_POST['update_status'])) {
            $taskId = (int)($_POST['task_id'] ?? 0);
            $status = $_POST['status'] ?? '';
            if ($taskId > 0 && in_array($status, ['active', 'inactive', 'completed'], true)) {
                $stmt = $db->prepare('UPDATE tasks SET status = ? WHERE id = ?');
                $stmt->bind_param('si', $status, $taskId);
                $stmt->execute();
                $stmt->close();
                $message = 'Task updated.';
            }
        }
    }
}

$res = $db->query('SELECT id, title, reward_amount, status, created_at FROM tasks ORDER BY created_at DESC');
$tasks = $res ? $res->fetch_all(MYSQLI_ASSOC) : [];

include __DIR__ . '/admin_header.php';
?>
    <section class="card">
        <div class="card-header">
            <div>
                <h3>Create task</h3>
                <span>New earning opportunities for users</span>
            </div>
        </div>
        <?php if ($message !== ''): ?>
            <div class="alert" style="background:rgba(34,197,94,0.12);border:1px solid rgba(34,197,94,0.6);color:#166534">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>
        <form method="post" style="display:grid;grid-template-columns:repeat(auto-fit,minmax(160px,1fr));gap:10px;align-items:flex-end">
            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($_SESSION['csrf_token_admin_tasks']); ?>">
            <div class="form-group" style="margin-bottom:0">
                <label for="title">Title</label>
                <input type="text" id="title" name="title" required>
            </div>
            <div class="form-group" style="margin-bottom:0">
                <label for="reward_amount">Reward amount</label>
                <input type="number" step="0.01" id="reward_amount" name="reward_amount" required>
            </div>
            <div class="form-group" style="margin-bottom:0">
                <label for="description">Short description</label>
                <input type="text" id="description" name="description">
            </div>
            <button type="submit" name="create_task" value="1" class="btn-primary" style="width:auto;padding-inline:18px">Add task</button>
        </form>
    </section>
    <section class="card card-subtle">
        <div class="card-header">
            <div>
                <h3>All tasks</h3>
                <span>Manage visibility and status</span>
            </div>
        </div>
        <table class="table-simple">
            <thead>
            <tr>
                <th>Title</th>
                <th>Reward</th>
                <th>Status</th>
                <th>Created</th>
                <th>Actions</th>
            </tr>
            </thead>
            <tbody>
            <?php if (!$tasks): ?>
                <tr>
                    <td colspan="5" style="font-size:12px;color:var(--text-muted)">No tasks yet.</td>
                </tr>
            <?php else: ?>
                <?php foreach ($tasks as $task): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($task['title']); ?></td>
                        <td>$<?php echo number_format($task['reward_amount'], 2); ?></td>
                        <td><?php echo htmlspecialchars($task['status']); ?></td>
                        <td><?php echo htmlspecialchars($task['created_at']); ?></td>
                        <td>
                            <form method="post" style="display:inline-flex;gap:4px;align-items:center">
                                <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($_SESSION['csrf_token_admin_tasks']); ?>">
                                <input type="hidden" name="task_id" value="<?php echo (int)$task['id']; ?>">
                                <select name="status" style="font-size:11px;border-radius:999px;padding:3px 8px">
                                    <option value="active" <?php echo $task['status'] === 'active' ? 'selected' : ''; ?>>active</option>
                                    <option value="inactive" <?php echo $task['status'] === 'inactive' ? 'selected' : ''; ?>>inactive</option>
                                    <option value="completed" <?php echo $task['status'] === 'completed' ? 'selected' : ''; ?>>completed</option>
                                </select>
                                <button type="submit" name="update_status" value="1" style="font-size:11px;border-radius:999px;padding:4px 9px;border:none;background:var(--accent-soft);color:var(--accent-primary);cursor:pointer">
                                    Save
                                </button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
            </tbody>
        </table>
    </section>
<?php
include __DIR__ . '/admin_footer.php';
